/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.mojang.datafixers.util.Unit;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import malte0811.ferritecore.hash.LambdaBasedHash;
import malte0811.ferritecore.mixin.dedupbakedquad.BakedQuadAccess;
import malte0811.ferritecore.util.PredicateHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import org.apache.commons.lang3.tuple.Pair;

public class Deduplicator {
    private static final Map<String, String> VARIANT_IDENTITIES = new ConcurrentHashMap<String, String>();
    private static final Map<List<Pair<Predicate<BlockState>, IBakedModel>>, MultipartBakedModel> KNOWN_MULTIPART_MODELS = new ConcurrentHashMap<List<Pair<Predicate<BlockState>, IBakedModel>>, MultipartBakedModel>();
    private static final Map<List<Predicate<BlockState>>, Predicate<BlockState>> OR_PREDICATE_CACHE = new ConcurrentHashMap<List<Predicate<BlockState>>, Predicate<BlockState>>();
    private static final Map<List<Predicate<BlockState>>, Predicate<BlockState>> AND_PREDICATE_CACHE = new ConcurrentHashMap<List<Predicate<BlockState>>, Predicate<BlockState>>();
    private static final Object2ObjectOpenCustomHashMap<int[], int[]> BAKED_QUAD_CACHE = new Object2ObjectOpenCustomHashMap(new LambdaBasedHash<int[]>(Arrays::hashCode, Arrays::equals));

    public static String deduplicateVariant(String variant) {
        return VARIANT_IDENTITIES.computeIfAbsent(variant, Function.identity());
    }

    public static MultipartBakedModel makeMultipartModel(List<Pair<Predicate<BlockState>, IBakedModel>> selectors) {
        return KNOWN_MULTIPART_MODELS.computeIfAbsent(selectors, MultipartBakedModel::new);
    }

    public static Predicate<BlockState> or(List<Predicate<BlockState>> list) {
        return OR_PREDICATE_CACHE.computeIfAbsent(list, PredicateHelper::or);
    }

    public static Predicate<BlockState> and(List<Predicate<BlockState>> list) {
        return AND_PREDICATE_CACHE.computeIfAbsent(list, PredicateHelper::and);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deduplicate(BakedQuad bq) {
        Object2ObjectOpenCustomHashMap<int[], int[]> object2ObjectOpenCustomHashMap = BAKED_QUAD_CACHE;
        synchronized (object2ObjectOpenCustomHashMap) {
            int[] deduped = (int[])BAKED_QUAD_CACHE.computeIfAbsent((Object)bq.func_178209_a(), Function.identity());
            ((BakedQuadAccess)bq).setVertexData(deduped);
        }
    }

    public static void registerReloadListener() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new ReloadListener<Unit>(){

            protected Unit prepare(IResourceManager iResourceManager, IProfiler iProfiler) {
                return Unit.INSTANCE;
            }

            protected void apply(Unit object, IResourceManager iResourceManager, IProfiler iProfiler) {
                VARIANT_IDENTITIES.clear();
                KNOWN_MULTIPART_MODELS.clear();
                OR_PREDICATE_CACHE.clear();
                AND_PREDICATE_CACHE.clear();
                BAKED_QUAD_CACHE.clear();
                BAKED_QUAD_CACHE.trim();
            }
        });
    }
}

